import sys, os, cv2
import numpy as np
from keras.models import load_model
from keras.callbacks import *
import tensorflow as tf

if __name__ == "__main__":
    m = load_model("EDSR.h5", custom_objects={"tf": tf})

    fn = sys.argv[1]
    lr = cv2.imread(fn)[:, :, ::-1]

    im = m.predict(lr[None, :])[0]
    im = np.clip(im, 0, 255).round().astype("uint8")
    cv2.imwrite("x8.png", im[:, :, ::-1])
