import sys, os, cv2
import numpy as np
import tensorflow as tf
tf.enable_eager_execution()
from tensorflow.keras.models import load_model

if __name__ == "__main__":
    m = load_model("SICNN.h5")

    fn = sys.argv[1]
    im = cv2.imread(fn)[:, :, ::-1]

    sr = m.predict(im[None, :])[0]
    sr = np.clip(sr, 0, 255).round().astype("uint8")
    cv2.imwrite("x8.png", sr[:, :, ::-1])
