import sys, os, cv2
from keras.models import load_model
import numpy as np

if __name__ == "__main__":
    m = load_model("SRCNN_model.h5")

    fn = sys.argv[1]
    lr = cv2.imread(fn)[:, :, ::-1]

    ilr = cv2.resize(lr, fx=8, fy=8, dsize=(0, 0),
                     interpolation=cv2.INTER_CUBIC)
    im = m.predict(ilr[None, :])[0]
    im = np.clip(im, 0, 255).round().astype("uint8")
    cv2.imwrite("x8.png", im[:, :, ::-1])
