import sys, os, cv2
import tensorflow as tf
import numpy as np

if __name__ == "__main__":
    m = tf.keras.models.load_model("srgan_model.h5", 
                                   custom_objects={"tf": tf})

    fn = sys.argv[1]
    lr = cv2.imread(fn)[:, :, ::-1]
    x8 = m.predict(lr[None, :])[0]
    x8 = np.clip(x8, 0, 255).round().astype("uint8")

    cv2.imwrite("x8.png", x8[:, :, ::-1])
