import sys, os, cv2
from keras.models import load_model
import tensorflow as tf
import numpy as np

if __name__ == "__main__":
    m = load_model("C-SRIP_model.h5",
                   custom_objects={"tf": tf})

    fn = sys.argv[1]
    lr = cv2.imread(fn)[:, :, ::-1]
    x2, x4, x8 = m.predict(lr[None, :])

    x2 = np.clip(x2[0], 0, 255).round().astype("uint8")
    x4 = np.clip(x4[0], 0, 255).round().astype("uint8")
    x8 = np.clip(x8[0], 0, 255).round().astype("uint8")

    cv2.imwrite("x2.png", x2[:, :, ::-1])
    cv2.imwrite("x4.png", x4[:, :, ::-1])
    cv2.imwrite("x8.png", x8[:, :, ::-1])

